package demo;

import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.List;

import javax.swing.GroupLayout;
import javax.swing.GroupLayout.Alignment;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;

import rk.netDevice.sdk.p3.*;

public class SwingDemo extends JFrame {
	private JTextField txtPort;
	private JTextField txtIP;
	private JTextField txtDeviceAddr;
	private JTextField txtParamIds;
	private JTextField txtParamId;
	private JTextField txtParamValue;
	private JTextArea textArea;

	public SwingDemo() {
		DeviceService.getInstance().addDataListener(new IDataListener() {

			@Override
			public void receiveTimingAck(TimingAck ack) {
				textArea.append("УʱӦ->豸:" + ack.getDeviceAddr() + "\tִн" + ack.getExecResult() + "\r\n");
			}

			@Override
			public void receiveTelecontrolAck(TelecontrolAck data) {
				StringBuilder sb = new StringBuilder();
				sb.append("ңӦ->豸:" + data.getDeviceAddr());
				for (RelayStatus rs : data.getRelayStatusList())
					sb.append("\t̵:" + rs.getRelayNo() + ",ִн:" + rs.getExecResult() + ",ǰ״̬:"
							+ rs.getCurrStatus());
				textArea.append(sb.toString() + "\r\n");

			}

			@Override
			public void receiveStoreDataCount(StoreDataCount data) {

				textArea.append("豸" + data.getDeviceAddr() + "洢:" + data.getCount() + "\r\n");

			}

			@Override
			public void receiveStoreDataAck(StoreDataAck data) {

				StringBuilder sb = new StringBuilder();
				for (NodeData nd : data.getNodeDataList()) {
					sb.append(nd.toString() + "\r\n");
				}
				textArea.append("ٻѴ洢->豸:" + data.getDeviceAddr() + "Ѵ洢ݹ" + data.getTotalCount() + ",ʣ"
						+ data.getSurplusCount() + "\r\n" + sb.toString());

			}

			@Override
			public void receiveStoreData(StoreData data) {
				StringBuilder sb = new StringBuilder();
				for (NodeData nd : data.getNodeDataList()) {
					sb.append(nd.toString() + "\r\n");
				}
				textArea.append("ϴѴ洢->豸:" + data.getDeviceAddr() + "\r\n" + sb.toString());

			}

			@Override
			public void receiveRealTimeData(RealTimeData data) {
				StringBuilder sb = new StringBuilder();
				for (NodeData nd : data.getNodeDataList()) {
					sb.append(nd.toString() + "\r\n");
				}
				textArea.append("ʵʱ->豸:" + data.getDeviceAddr() + "\r\n" + sb.toString());

			}

			@Override
			public void receiveParamItems(ParamItems data) {
				StringBuilder sb = new StringBuilder();
				for (ParamItem item : data.getParamItemList()) {
					sb.append(":" + item.getParamId() + ",:" + item.getParamName() + ",ֵ:" + item.getValue()
							+ "\r\n");
				}
				textArea.append("豸->豸:" + data.getDeviceAddr() + "\r\n" + sb.toString());

			}

			@Override
			public void receiveParamIds(ParamIds data) {

				String idList = "";
				for (Short id : data.getIdList())
					idList += id + ",";
				textArea.append("豸б->豸:" + data.getDeviceAddr() + ",:" + data.getTotalDictCount()
						+ ",:" + idList + "\r\n");
			}

			@Override
			public void receiveLoginData(LoginData data) {
				textArea.append("豸¼->豸:" + data.getDeviceAddr() + "\r\n");

			}

			@Override
			public void receiveDataTransAck(DataTransAck arg0) {
				// TODO Auto-generated method stub

			}

			@Override
			public void receiveAffectedParamItems(AffectedParamItems data) {

				String idList = "";
				for (Short id : data.getParamIdList())
					idList += id + ",";

				textArea.append("豸Ӧ->豸:" + data.getDeviceAddr() + ",ӰĲ:" + idList + "\r\n");
			}
		});
		DeviceService.getInstance().setParamFile("E:/NetDeviceParam.dat");
		setResizable(false);
		setTitle("Demo");
		setSize(700, 800);
		setLocationRelativeTo(null);
		getContentPane().setLayout(null);

		JPanel panel = new JPanel();
		panel.setBorder(
				new TitledBorder(null, "\u670D\u52A1\u8BBE\u7F6E", TitledBorder.LEADING, TitledBorder.TOP, null, null));
		panel.setBounds(5, 5, 673, 62);
		getContentPane().add(panel);
		panel.setLayout(null);

		JLabel lblNewLabel = new JLabel("\u76D1\u542C\u7AEF\u53E3");
		lblNewLabel.setBounds(145, 20, 54, 15);
		panel.add(lblNewLabel);

		txtPort = new JTextField();
		txtPort.setText("2404");
		txtPort.setBounds(204, 17, 66, 21);
		panel.add(txtPort);
		txtPort.setColumns(10);

		JButton btnStart = new JButton("\u542F\u52A8");
		btnStart.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				new Thread(new Runnable() {

					@Override
					public void run() {
						// TODO Auto-generated method stub

						try {
							btnStart.setEnabled(false);
							DeviceService.getInstance().start(txtIP.getText(), Integer.parseInt(txtPort.getText()));
						} catch (NumberFormatException e1) {
							// TODO Auto-generated catch block
							e1.printStackTrace();
						} catch (InterruptedException e1) {
							// TODO Auto-generated catch block
							e1.printStackTrace();
						}
					}
				}).start();
			}
		});
		btnStart.setBounds(280, 16, 93, 23);
		panel.add(btnStart);

		JButton btnStop = new JButton("\u505C\u6B62");
		btnStop.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				DeviceService.getInstance().stop();
				btnStart.setEnabled(true);
			}
		});
		btnStop.setBounds(384, 16, 93, 23);
		panel.add(btnStop);

		JLabel lblip = new JLabel("\u76D1\u542CIP");
		lblip.setBounds(10, 20, 54, 15);
		panel.add(lblip);

		txtIP = new JTextField();
		txtIP.setText("127.0.0.1");
		txtIP.setColumns(10);
		txtIP.setBounds(69, 17, 66, 21);
		panel.add(txtIP);

		JLabel lblNewLabel_1 = new JLabel("\u8BBE\u5907\u5730\u5740");
		lblNewLabel_1.setBounds(10, 77, 54, 15);
		getContentPane().add(lblNewLabel_1);

		txtDeviceAddr = new JTextField();
		txtDeviceAddr.setText("10000000");
		txtDeviceAddr.setColumns(10);
		txtDeviceAddr.setBounds(74, 74, 66, 21);
		getContentPane().add(txtDeviceAddr);

		JButton btnTiming = new JButton("\u6821\u65F6");
		btnTiming.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				DeviceService.getInstance().timing(Integer.parseInt(txtDeviceAddr.getText()), (short) 0);
			}
		});
		btnTiming.setBounds(5, 100, 93, 23);
		getContentPane().add(btnTiming);

		JButton btnCallRealtimeData = new JButton("\u53EC\u5524\u5B9E\u65F6\u6570\u636E");
		btnCallRealtimeData.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				DeviceService.getInstance().callRealTimeData(Integer.parseInt(txtDeviceAddr.getText()), (short) 0);
			}
		});
		btnCallRealtimeData.setBounds(108, 100, 122, 23);
		getContentPane().add(btnCallRealtimeData);

		JButton btnReadStoreDataCount = new JButton("\u8BFB\u53D6\u5B58\u50A8\u6570\u636E\u6761\u6570");
		btnReadStoreDataCount.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {

				DeviceService.getInstance().readStoreDataCount(Integer.parseInt(txtDeviceAddr.getText()), (short) 0);
			}
		});
		btnReadStoreDataCount.setBounds(240, 100, 154, 23);
		getContentPane().add(btnReadStoreDataCount);

		JButton btnReadStoreData = new JButton("\u8BFB\u53D6\u5B58\u50A8\u6570\u636E");
		btnReadStoreData.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				DeviceService.getInstance().readStoreData(Integer.parseInt(txtDeviceAddr.getText()), (short) 0);
			}
		});
		btnReadStoreData.setBounds(404, 100, 154, 23);
		getContentPane().add(btnReadStoreData);

		JButton btnReboot = new JButton("\u91CD\u542F\u8BBE\u5907");
		btnReboot.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				DeviceService.getInstance().reboot(Integer.parseInt(txtDeviceAddr.getText()), (short) 0);
			}
		});
		btnReboot.setBounds(565, 100, 107, 23);
		getContentPane().add(btnReboot);

		JPanel panel_1 = new JPanel();
		panel_1.setBorder(new TitledBorder(null,

				"\u7EE7\u7535\u5668\u63A7\u5236", TitledBorder.LEADING,

				TitledBorder.TOP, null, null));
		panel_1.setBounds(5, 137, 624, 57);
		getContentPane().add(panel_1);

		JCheckBox chkRelay0 = new JCheckBox("\u7EE7\u7535\u56680");
		panel_1.add(chkRelay0);

		JCheckBox chkRelay1 = new JCheckBox("\u7EE7\u7535\u56681");
		panel_1.add(chkRelay1);

		JCheckBox chkRelay2 = new JCheckBox("\u7EE7\u7535\u56682");
		panel_1.add(chkRelay2);

		JCheckBox chkRelay3 = new JCheckBox("\u7EE7\u7535\u56683");
		panel_1.add(chkRelay3);

		JCheckBox chkRelay4 = new JCheckBox("\u7EE7\u7535\u56684");
		panel_1.add(chkRelay4);

		JCheckBox chkRelay5 = new JCheckBox("\u7EE7\u7535\u56685");
		panel_1.add(chkRelay5);

		JCheckBox chkRelay6 = new JCheckBox("\u7EE7\u7535\u56686");
		panel_1.add(chkRelay6);

		JCheckBox chkRelay7 = new JCheckBox("\u7EE7\u7535\u56687");
		panel_1.add(chkRelay7);

		JButton btnReadParamItemsIds = new JButton("\u8BFB\u53D6\u8BBE\u5907\u53C2\u6570\u7F16\u53F7\u5217\u8868");
		btnReadParamItemsIds.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				DeviceService.getInstance().readParamItemsIds(Integer.parseInt(txtDeviceAddr.getText()), (short) 0);
			}
		});
		btnReadParamItemsIds.setBounds(504, 210, 168, 23);
		getContentPane().add(btnReadParamItemsIds);

		JLabel lblNewLabel_2 = new JLabel("\u53C2\u6570\u7F16\u53F7");
		lblNewLabel_2.setBounds(10, 247, 54, 15);
		getContentPane().add(lblNewLabel_2);

		txtParamIds = new JTextField();
		txtParamIds.setText("1,2,3,4,5");
		txtParamIds.setBounds(62, 244, 439, 21);
		getContentPane().add(txtParamIds);
		txtParamIds.setColumns(10);

		JButton btnReadParamItems = new JButton("\u8BFB\u53D6\u8BBE\u5907\u53C2\u6570");
		btnReadParamItems.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				try {
					List<Short> paramIds = new ArrayList<Short>();
					String[] ids = txtParamIds.getText().split(",");
					for (String id : ids) {
						try {
							paramIds.add(Short.parseShort(id));
						} catch (Exception ex) {
							// TODO: handle exception
						}
					}
					DeviceService.getInstance().readParamItems(Integer.parseInt(txtDeviceAddr.getText()), (short) 0,
							paramIds);
				} catch (NumberFormatException e1) {
					// TODO Auto-generated catch block
					e1.printStackTrace();
				} catch (Exception e1) {
					// TODO Auto-generated catch block
					e1.printStackTrace();
				}
			}
		});
		btnReadParamItems.setBounds(504, 243, 168, 23);
		getContentPane().add(btnReadParamItems);

		JLabel lblNewLabel_2_1 = new JLabel("\u53C2\u6570\u7F16\u53F7");
		lblNewLabel_2_1.setBounds(10, 279, 54, 15);
		getContentPane().add(lblNewLabel_2_1);

		txtParamId = new JTextField();
		txtParamId.setColumns(10);
		txtParamId.setBounds(62, 276, 66, 21);
		getContentPane().add(txtParamId);

		JLabel lblNewLabel_2_1_1 = new JLabel("\u53C2\u6570\u7F16\u53F7");
		lblNewLabel_2_1_1.setBounds(153, 279, 54, 15);
		getContentPane().add(lblNewLabel_2_1_1);

		txtParamValue = new JTextField();
		txtParamValue.setColumns(10);
		txtParamValue.setBounds(205, 276, 66, 21);
		getContentPane().add(txtParamValue);

		JButton btnWriteParam = new JButton("\u4E0B\u8F7D\u8BBE\u5907\u53C2\u6570");
		btnWriteParam.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				try {
					List<ParamItem> items = new ArrayList<ParamItem>();
					items.add(ParamItem.create(Short.parseShort(txtParamId.getText()), txtParamValue.getText()));
					DeviceService.getInstance().writeParamItems(Integer.parseInt(txtDeviceAddr.getText()), (short) 0,
							items);
				} catch (NumberFormatException e1) {
					// TODO Auto-generated catch block
					e1.printStackTrace();
				} catch (Exception e1) {
					// TODO Auto-generated catch block
					e1.printStackTrace();
				}
			}
		});
		btnWriteParam.setBounds(504, 275, 168, 23);
		getContentPane().add(btnWriteParam);

		JPanel panel_2 = new JPanel();
		panel_2.setBorder(
				new TitledBorder(null, "\u63A5\u6536\u6570\u636E", TitledBorder.LEADING, TitledBorder.TOP, null, null));
		panel_2.setBounds(10, 304, 668, 457);
		getContentPane().add(panel_2);
		
		JScrollPane scrollPane = new JScrollPane();
		GroupLayout gl_panel_2 = new GroupLayout(panel_2);
		gl_panel_2.setHorizontalGroup(
			gl_panel_2.createParallelGroup(Alignment.LEADING)
				.addComponent(scrollPane, GroupLayout.DEFAULT_SIZE, 656, Short.MAX_VALUE)
		);
		gl_panel_2.setVerticalGroup(
			gl_panel_2.createParallelGroup(Alignment.LEADING)
				.addComponent(scrollPane, GroupLayout.DEFAULT_SIZE, 433, Short.MAX_VALUE)
		);
		
		 textArea = new JTextArea();
		textArea.setMargin(new Insets(0, 0, 0, 0));
		scrollPane.setViewportView(textArea);
		panel_2.setLayout(gl_panel_2);

		chkRelay7.addItemListener(new ChkItemListener((short) 15007));
		chkRelay6.addItemListener(new ChkItemListener((short) 15006));
		chkRelay5.addItemListener(new ChkItemListener((short) 15005));
		chkRelay4.addItemListener(new ChkItemListener((short) 15004));
		chkRelay3.addItemListener(new ChkItemListener((short) 15003));
		chkRelay2.addItemListener(new ChkItemListener((short) 15002));
		chkRelay1.addItemListener(new ChkItemListener((short) 15001));
		chkRelay0.addItemListener(new ChkItemListener((short) 15000));
	}

	class ChkItemListener implements ItemListener {

		private short relayNo = 0;

		public ChkItemListener(short relayNo) {
			this.relayNo = relayNo;
		}

		@Override
		public void itemStateChanged(ItemEvent e) {
			JCheckBox jcb = (JCheckBox) e.getItem();
			int deviceId = Integer.parseInt(txtDeviceAddr.getText());
			if (jcb.isSelected()) {

				try {
					List<TelecontrolParam> paramList = new ArrayList<TelecontrolParam>();
					paramList.add(new TelecontrolParam(relayNo, (short) 1, (short) 0));
					DeviceService.getInstance().telecontrol(deviceId, (short) 0, paramList);
				} catch (Exception e1) {
					e1.printStackTrace();
				}

			} else {
				try {
					List<TelecontrolParam> paramList = new ArrayList<TelecontrolParam>();
					paramList.add(new TelecontrolParam(relayNo, (short) 0, (short) 0));
					DeviceService.getInstance().telecontrol(deviceId, (short) 0, paramList);
				} catch (Exception e1) {
					e1.printStackTrace();
				}
			}
		}

	}

	public static void main(String[] args) {
		new SwingDemo().setVisible(true);

	}
}
