package demo;

import rk.netDevice.sdk.p2.*;

import java.io.IOException;
import java.text.SimpleDateFormat;


public class Demo {

	public static void main(String[] args) throws IOException,
			InterruptedException {
		RSServer rsServer = RSServer.Initiate(2404);// ʼ
		rsServer.addDataListener(new IDataListener() {// Ӽ
			@Override
			public void receiveTimmingAck(TimmingAck data) {// УʱָӦ
				System.out.println("УʱӦ->豸:" + data.getDeviceId()
						+ "\tִн" + data.getStatus());
			}

			@Override
			public void receiveTelecontrolAck(TelecontrolAck data) {// ңָӦ
				System.out.println("ңӦ->豸:" + data.getDeviceId()
						+ "\t̵:" + data.getRelayId() + "\tִн:"
						+ data.getStatus());
			}

			@Override
			public void receiveStoreData(StoreData data) {// Ѵ洢ݽմ
				// ڵݡݰ豸Լڵݡʪݴڽڵ
				for (NodeData nd : data.getNodeList()) {
					SimpleDateFormat sdf = new SimpleDateFormat(
							"yy-MM-dd HH:mm:ss");
					String str = sdf.format(nd.getRecordTime());
					System.out.println("洢->豸ַ:" + data.getDeviceId()
							+ "\tڵ:" + nd.getNodeId() + "\t¶:" + nd.getTem()
							+ "\tʪ:" + nd.getHum() + "\t洢ʱ:" + str);
				}

			}

			@Override
			public void receiveRealtimeData(RealTimeData data) {// ʵʱݽմ
				// ڵݡݰ豸Լڵݡʪݴڽڵ
				for (NodeData nd : data.getNodeList()) {
					System.out.println("ʵʱ->豸ַ:" + data.getDeviceId()
							+ "\tڵ:" + nd.getNodeId() + "\t¶:" + nd.getTem()
							+ "\tʪ:" + nd.getHum() + "\t:" + data.getLng()
							+ "\tγ:" + data.getLat() + "\t:"
							+ data.getCoordinateType() + "\t̵״̬:"
							+ data.getRelayStatus());
				}

			}

			@Override
			public void receiveLoginData(LoginData data) {// ¼ݽմ
				System.out.println("¼->豸ַ:" + data.getDeviceId());

			}

			@Override
			public void receiveParamIds(ParamIdsData data) {
				String str = "豸б->豸ţ" + data.getDeviceId()
						+ "\t" + data.getTotalCount() + "\t֡"
						+ data.getCount() + "\r\n";
				for (int paramId : data.getPararmIdList())// 豸вid
				{
					str += paramId + ",";
				}
				System.out.println(str);

			}

			@Override
			public void receiveParam(ParamData data) {
				String str = "豸->豸ţ" + data.getDeviceId() + "\r\n";

				for (ParamItem pararm : data.getParameterList()) {
					str += "ţ"
							+ pararm.getParamId()
							+ "\t"
							+ pararm.getDescription()
							+ "\tֵ"
							+ (pararm.getValueDescription() == null ? pararm
									.getValue() : pararm.getValueDescription()
									.get(pararm.getValue())) + "\r\n";
				}
				System.out.println(str);

			}

			@Override
			public void receiveWriteParamAck(WriteParamAck data) {
				String str = "豸->豸ţ" + data.getDeviceId() + "\t"
						+ data.getCount() + "\t"
						+ (data.isSuccess() ? "سɹ" : "ʧ");
				System.out.println(str);

			}

			@Override
			public void receiveTransDataAck(TransDataAck data) {
				String str = "͸->豸ţ" + data.getDeviceId() + "\tӦ"
						+ data.getData() + "\r\nֽ" + data.getTransDataLen();
				System.out.println(str);

			}

			@Override
			public void receiveHeartbeatData(HeartbeatData heartbeatData) {

			}
		});
		rsServer.start();

	}

}
