﻿using RK.NetDevice.SDK.P3;
using RK.NetDevice.SDK.P3.DataPackage.Data;
using RK.NetDevice.SDK.P3.Model;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace RKDeviceDemo
{
    public partial class FormMain : Form
    {
        public FormMain()
        {
            InitializeComponent();
        }

        private void Form1_Load(object sender, EventArgs e)
        {
            

        }

        private void btnStart_Click(object sender, EventArgs e)
        {
            if (btnStart.Text == "启动")
            {
                DeviceService.Instance.OnReceiveLoginData -= Instance_OnReceiveLoginData;
                DeviceService.Instance.OnReceiveLoginData += Instance_OnReceiveLoginData;

                DeviceService.Instance.OnReceiveRealTimeData -= Instance_OnReceiveRealTimeData;
                DeviceService.Instance.OnReceiveRealTimeData += Instance_OnReceiveRealTimeData;

                DeviceService.Instance.OnReceiveStoreData -= Instance_OnReceiveStoreData;
                DeviceService.Instance.OnReceiveStoreData += Instance_OnReceiveStoreData;


                DeviceService.Instance.OnReceiveStoreDataCount -= Instance_OnReceiveStoreDataCount;
                DeviceService.Instance.OnReceiveStoreDataCount += Instance_OnReceiveStoreDataCount;

                DeviceService.Instance.OnReceiveStoreDataAck -= Instance_OnReceiveStoreDataAck;
                DeviceService.Instance.OnReceiveStoreDataAck += Instance_OnReceiveStoreDataAck;


                DeviceService.Instance.OnReceiveTelecontrolAck -= Instance_OnReceiveTelecontrolAck;
                DeviceService.Instance.OnReceiveTelecontrolAck += Instance_OnReceiveTelecontrolAck;

                DeviceService.Instance.OnReceiveTimingAck -= Instance_OnReceiveTimingAck;
                DeviceService.Instance.OnReceiveTimingAck += Instance_OnReceiveTimingAck;

                DeviceService.Instance.OnReceiveParamIds -= Instance_OnReceiveParamIds;
                DeviceService.Instance.OnReceiveParamIds += Instance_OnReceiveParamIds;

                DeviceService.Instance.OnReceiveParamItems -= Instance_OnReceiveParamItems;
                DeviceService.Instance.OnReceiveParamItems += Instance_OnReceiveParamItems;

                DeviceService.Instance.OnReceiveAffectedParamItems -= Instance_OnReceiveAffectedParamItems;
                DeviceService.Instance.OnReceiveAffectedParamItems += Instance_OnReceiveAffectedParamItems;


                if (DeviceService.Instance.Start("", int.Parse(txtPort.Text)))
                {
                    btnStart.Text = "停止";
                }
            }
            else
            {
                if (DeviceService.Instance.Stop())
                {
                    btnStart.Text = "启动";
                }
            }
        }

        private void Instance_OnReceiveAffectedParamItems(AffectedParamItems ack)
        {
            Invoke(new Action(() =>
            {
                rhtResult.AppendText($"{DateTime.Now}\t设备{ack.DeviceAddr}受影响的参数编号{string.Join(",", ack.ParamIdList)}\r\n");

            }));
        }

        private void Instance_OnReceiveParamItems(ParamItems ack)
        {
            Invoke(new Action(() =>
            {
                StringBuilder sb = new StringBuilder();
                foreach (ParamItem item in ack.ParamItemList)
                {
                    sb.Append($"参数编号:{item.ParamId},参数名称{item.ParamName},参数值:{item.Value}\r\n");
                }
                rhtResult.AppendText($"{DateTime.Now}\t设备{ack.DeviceAddr},参数:{sb}\r\n");

            }));
        }

        private void Instance_OnReceiveParamIds(ParamIds ack)
        {
            Invoke(new Action(() =>
            {
                rhtResult.AppendText($"{DateTime.Now}\t设备{ack.DeviceAddr},参数数量{ack.TotalDictCount},参数编号{string.Join(",", ack.IdList)}\r\n");

            }));
        }





        private void Instance_OnReceiveTimingAck(TimingAck ack)
        {
            Invoke(new Action(() =>
            {
                rhtResult.AppendText($"{DateTime.Now}\t设备{ack.DeviceAddr}校时{(ack.ExecResult == 1 ? "成功" : "失败")}\r\n");

            }));
        }

        private void Instance_OnReceiveStoreDataAck(StoreDataAck ack)
        {
            Invoke(new Action(() =>
            {
                StringBuilder sb = new StringBuilder();
                foreach (NodeData nd in ack.NodeDataList)
                {
                    sb.Append($"{nd}\r\n");
                }

                rhtResult.AppendText($"{DateTime.Now}\t设备{ack.DeviceAddr}已存储数据共{ack.TotalCount}条，剩余{ack.SurplusCount}条\r\n{sb}");

            }));
        }

        private void Instance_OnReceiveStoreDataCount(StoreDataCount data)
        {
            Invoke(new Action(() =>
            {
                rhtResult.AppendText($"{DateTime.Now}\t设备{data.DeviceAddr}存储数据{data.Count}条\r\n");
            }));
        }



        private void Instance_OnReceiveStoreData(StoreData data)
        {
            Invoke(new Action(() =>
            {
                StringBuilder sb = new StringBuilder();
                foreach (NodeData nd in data.NodeDataList)
                {
                    sb.Append($"{nd}\r\n");
                }

                rhtResult.AppendText($"{DateTime.Now}\t已存储数据->设备{data.DeviceAddr}\r\n{sb}");

            }));
        }

        private void Instance_OnReceiveTelecontrolAck(TelecontrolAck ack)
        {
            Invoke(new Action(() =>
            {
                StringBuilder sb = new StringBuilder();
                foreach (RelayStatus rs in ack.RelayStatusList)
                {
                    sb.Append($"继电器编号:{rs.RelayNo},执行情况:{rs.ExecResult},当前状态:{rs.CurrStatus}\r\n");
                }
                rhtResult.AppendText($"{DateTime.Now}\t设备{ack.DeviceAddr}继电器操作响应\r\n{sb}");
            }));
        }

        private void Instance_OnReceiveRealTimeData(RealTimeData data)
        {
            Invoke(new Action(() =>
            {
                StringBuilder sb = new StringBuilder();
                foreach (NodeData nd in data.NodeDataList)
                {
                    sb.Append($"{nd}\r\n");
                }

                rhtResult.AppendText($"{DateTime.Now}\t实时数据->设备{data.DeviceAddr}\r\n{sb}");

            }));
        }

        private void Instance_OnReceiveLoginData(LoginData data)
        {
            Invoke(new Action(() =>
            {
                rhtResult.AppendText($"{DateTime.Now}\t设备{data.DeviceAddr}登录\r\n");
            }));
        }

        private void btnTimming_Click(object sender, EventArgs e)
        {
            DeviceService.Instance.Timing(int.Parse(txtDeviceAddr.Text), 0);

        }

        private void btnCallRealtimeData_Click(object sender, EventArgs e)
        {
            DeviceService.Instance.CallRealTimeData(int.Parse(txtDeviceAddr.Text), 0);
        }

        private void btnReadStoreDataCount_Click(object sender, EventArgs e)
        {
            DeviceService.Instance.ReadStoreDataCount(Convert.ToInt32(txtDeviceAddr.Text), 0);
        }

        private void btnReadStoreData_Click(object sender, EventArgs e)
        {
            DeviceService.Instance.ReadStoreData(Convert.ToInt32(txtDeviceAddr.Text), 0);
        }

        private void btnReboot_Click(object sender, EventArgs e)
        {
            DeviceService.Instance.Reboot(Convert.ToInt32(txtDeviceAddr.Text), 0);
        }
        private void chk_CheckedChanged(object sender, EventArgs e)
        {
            CheckBox chk = sender as CheckBox;
            short relayNo = (short)(Convert.ToInt16(chk.Tag)+ 15000);//继电器编号从15000开始
            short opt = (short)(chk.Checked ? 1 : 0);
            List<TelecontrolParam> paramList = new List<TelecontrolParam>();
            paramList.Add(new TelecontrolParam(relayNo, opt, 0));
            DeviceService.Instance.Telecontrol(Convert.ToInt32(txtDeviceAddr.Text), 0, paramList);//发送遥控指令

        }

        private void btnReadParamItemsIds_Click(object sender, EventArgs e)
        {
            DeviceService.Instance.ReadParamItemsIds(Convert.ToInt32(txtDeviceAddr.Text), 0);
        }

        private void btnReadParamItems_Click(object sender, EventArgs e)
        {
            List<short> paramIds = new List<short>();
            foreach (string str in txtParamIds.Text.Split(','))
            {
                paramIds.Add(short.Parse(str));
            }
            DeviceService.Instance.ReadParamItems(Convert.ToInt32(txtDeviceAddr.Text), 0, paramIds);
        }

        private void btnWriteParamItems_Click(object sender, EventArgs e)
        {
            List<ParamItem> items = new List<ParamItem>();
            items.Add(ParamItem.Create(short.Parse(txtDictId.Text), txtDictVal.Text));
            DeviceService.Instance.WriteParamItems(Convert.ToInt32(txtDeviceAddr.Text), 0, items);
        }
    }
}
